<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page-masterVertical"
				page-height="29.5cm" page-width="21cm" margin-top="0.5cm"
				margin-bottom="0.5cm" margin-left="1cm" margin-right="1cm">
				<fo:region-before margin-right="1cm" extent="3cm" />
				<fo:region-body margin-top="3cm" margin-bottom="1cm"
					font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt" />
				<fo:region-after extent="1cm" />
			</fo:simple-page-master>
			<fo:simple-page-master master-name="default-page-masterHorizontal"
				page-height="21cm" page-width="29.5cm" margin-top="0.5cm"
				margin-bottom="0.5cm" margin-left="1cm" margin-right="1cm">
				<fo:region-before margin-right="1cm" extent="3cm" />
				<fo:region-body margin-top="3cm" margin-bottom="1cm"
					font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt" />
				<fo:region-after extent="1cm" />
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>

	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set" />


			<fo:page-sequence id="my-sequence-id" master-reference="default-page-masterHorizontal">
				<fo:static-content flow-name="xsl-region-before">
						<fo:block>
							<fo:inline color="#800000" font-size="10pt"
								font-weight="bold"><xsl:value-of select="//informeDEC/cav" /></fo:inline>
						</fo:block>
						<fo:block>
							<fo:inline font-size="10pt" font-weight="bold"><xsl:value-of select="//informeDEC/titulo" /></fo:inline>
						</fo:block>
						<fo:block>
							<fo:inline font-size="10pt" font-weight="bold">
								<xsl:value-of select="//informeDEC/ejercicio" />
							</fo:inline>
						</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block text-align-last="justify"  font-size="10pt" font-weight="bold">
						<xsl:value-of select="//informeDEC/fechaHora"/>	
						<fo:leader leader-pattern="space" />
						<fo:page-number/> / <fo:page-number-citation ref-id="end"/>
					</fo:block>				
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>

						<fo:block>
							<xsl:text>&#xA;</xsl:text>
						</fo:block>
						<xsl:apply-templates select="informeDEC/corrM1" />
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>

					</fo:block>
				</fo:flow>
			</fo:page-sequence>

			<fo:page-sequence master-reference="default-page-masterHorizontal">
				<fo:static-content flow-name="xsl-region-before">
						<fo:block>
							<fo:inline color="#800000" font-size="10pt"
								font-weight="bold"><xsl:value-of select="//informeDEC/cav" /></fo:inline>
						</fo:block>
						<fo:block>
							<fo:inline font-size="10pt" font-weight="bold"><xsl:value-of select="//informeDEC/titulo" /></fo:inline>
						</fo:block>
						<fo:block>
							<fo:inline font-size="10pt" font-weight="bold">
								<xsl:value-of select="//informeDEC/ejercicio" />
							</fo:inline>
						</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block text-align-last="justify"  font-size="10pt" font-weight="bold">
						<xsl:value-of select="//informeDEC/fechaHora"/>	
						<fo:leader leader-pattern="space" />
						<fo:page-number/> / <fo:page-number-citation ref-id="end"/>
					</fo:block>				
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>

						<fo:block>
							<xsl:text>&#xA;</xsl:text>
						</fo:block>
						<xsl:apply-templates select="informeDEC/corrM2" />
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>

					</fo:block>
				</fo:flow>
			</fo:page-sequence>

<!-- 			<fo:page-sequence master-reference="default-page-masterVertical"> -->
<!-- 				<fo:static-content flow-name="xsl-region-before"> -->
<!-- 						<fo:block> -->
<!-- 							<fo:inline color="#800000" font-size="10pt" -->
<!-- 								font-weight="bold"><xsl:value-of select="//informeDEC/cav" /></fo:inline> -->
<!-- 						</fo:block> -->
<!-- 						<fo:block> -->
<!-- 							<fo:inline font-size="10pt" font-weight="bold"><xsl:value-of select="//informeDEC/titulo" /></fo:inline> -->
<!-- 						</fo:block> -->
<!-- 						<fo:block> -->
<!-- 							<fo:inline font-size="10pt" font-weight="bold"> -->
<!-- 								<xsl:value-of select="//informeDEC/ejercicio" /> -->
<!-- 							</fo:inline> -->
<!-- 						</fo:block> -->
<!-- 				</fo:static-content> -->
<!-- 				<fo:static-content flow-name="xsl-region-after"> -->
<!-- 					<fo:block text-align-last="justify"  font-size="10pt" font-weight="bold"> -->
<!-- 						<xsl:value-of select="//informeDEC/fechaHora"/>	 -->
<!-- 						<fo:leader leader-pattern="space" /> -->
<!-- 						<fo:page-number/> / <fo:page-number-citation ref-id="end"/> -->
<!-- 					</fo:block>				 -->
<!-- 				</fo:static-content> -->
<!-- 				<fo:flow flow-name="xsl-region-body"> -->
<!-- 					<fo:block> -->

<!-- 						<fo:block> -->
<!-- 							<xsl:text>&#xA;</xsl:text> -->
<!-- 						</fo:block> -->
<!-- 						<xsl:apply-templates select="informeDEC/corrM3" /> -->
<!-- 						<fo:block> -->
<!-- 							<fo:leader leader-pattern="space" /> -->
<!-- 						</fo:block> -->

<!-- 					</fo:block> -->
<!-- 				</fo:flow> -->
<!-- 			</fo:page-sequence> -->


		</fo:root>
	</xsl:template>



	<xsl:template match="informeDEC/corrM1">
						<fo:block>
							<fo:inline font-size="10pt" font-weight="bold"
								text-decoration="underline">
								<xsl:value-of select="//informeDEC/corrM1/ta01t" />
							</fo:inline>
						</fo:block>
						<fo:block>
							<fo:table width="100%" space-before.optimum="30pt"
								space-after.optimum="40pt">
								<fo:table-column column-width="27cm"></fo:table-column>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell padding-before="0cm" width="27cm"
											padding-start="3pt" padding-end="3pt" padding-after="3pt">
											<fo:block>
												<fo:table width="100%" space-before.optimum="4pt"
													space-after.optimum="4pt">
													<fo:table-column column-width="1.5cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="2.5cm"></fo:table-column>
													<fo:table-column column-width="2.5cm"></fo:table-column>
													<fo:table-column column-width="2.5cm"></fo:table-column>
													<fo:table-body>
														<fo:table-row>
															<fo:table-cell>
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f01c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f01c0204" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="2.7cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f01c0507" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell>
															</fo:table-cell>
															<fo:table-cell>
															</fo:table-cell>
															<fo:table-cell>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3.5cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c08" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c09" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f02c10" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f03c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f03c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f03c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f03c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f03c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f03c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f03c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f04c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f04c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f04c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f04c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f04c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f04c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f04c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
<!-- 															<fo:table-cell number-columns-spanned="7" border-after-color="#CAC9D9" -->
<!-- 																border-after-style="solid" border-after-width="thin" -->
<!-- 																border-before-color="#CAC9D9" border-before-style="solid" -->
<!-- 																border-before-width="thin" border-end-color="#CAC9D9" -->
<!-- 																border-end-style="solid" border-end-width="thin" -->
<!-- 																border-start-color="#CAC9D9" border-start-style="solid" -->
<!-- 																border-start-width="thin" width="3.5cm" padding-start="3pt" -->
<!-- 																padding-end="3pt" padding-before="3pt" padding-after="3pt" -->
<!-- 																border-style="solid" border-width="1pt" border-color="black"> -->
<!-- 															</fo:table-cell> -->



															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01l_f05c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f05c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f05c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f05c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f05c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f05c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f05c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>








															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f05c08" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f05c09" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta01v_f05c10" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>



						<fo:block>
							<fo:inline font-size="10pt" font-weight="bold"
								text-decoration="underline">
								<xsl:value-of select="//informeDEC/corrM1/ta02t" />
							</fo:inline>
						</fo:block>
						<fo:block>
							<fo:table width="100%" space-before.optimum="30pt"
								space-after.optimum="40pt">
								<fo:table-column column-width="27cm"></fo:table-column>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell padding-before="0cm" width="27cm"
											padding-start="3pt" padding-end="3pt" padding-after="3pt">
											<fo:block>
												<fo:table width="100%" space-before.optimum="4pt"
													space-after.optimum="4pt">
													<fo:table-column column-width="1.5cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="2.5cm"></fo:table-column>
													<fo:table-body>
														<fo:table-row>
															<fo:table-cell>
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f01c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f01c0204" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="2.7cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f01c0507" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3.5cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f02c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f02c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f02c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f02c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f02c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f02c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f02c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f02c08" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f03c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f03c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f03c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f03c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f03c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f03c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f03c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f04c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f04c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f04c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f04c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f04c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f04c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f04c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
<!-- 															<fo:table-cell number-columns-spanned="7" border-after-color="#CAC9D9" -->
<!-- 																border-after-style="solid" border-after-width="thin" -->
<!-- 																border-before-color="#CAC9D9" border-before-style="solid" -->
<!-- 																border-before-width="thin" border-end-color="#CAC9D9" -->
<!-- 																border-end-style="solid" border-end-width="thin" -->
<!-- 																border-start-color="#CAC9D9" border-start-style="solid" -->
<!-- 																border-start-width="thin" width="3.5cm" padding-start="3pt" -->
<!-- 																padding-end="3pt" padding-before="3pt" padding-after="3pt" -->
<!-- 																border-style="solid" border-width="1pt" border-color="black"> -->
<!-- 															</fo:table-cell> -->







															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02l_f05c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f05c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f05c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f05c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f05c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f05c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f05c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>










															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM1/ta02v_f05c08" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>


	</xsl:template>




	<xsl:template match="informeDEC/corrM2">
						<fo:block>
							<fo:inline font-size="10pt" font-weight="bold"
								text-decoration="underline">
								<xsl:value-of select="//informeDEC/corrM2/ta03t" />
							</fo:inline>
						</fo:block>
						<fo:block>
							<fo:table width="100%" space-before.optimum="13pt"
								space-after.optimum="6pt">
								<fo:table-column column-width="27cm"></fo:table-column>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell padding-before="0cm" width="27cm"
											padding-start="3pt" padding-end="3pt" padding-after="3pt">
											<fo:block>
												<fo:table width="100%" space-before.optimum="4pt"
													space-after.optimum="4pt">
													<fo:table-column column-width="1.5cm"></fo:table-column>
													<fo:table-column column-width="3.5cm"></fo:table-column>
													<fo:table-column column-width="3.5cm"></fo:table-column>
													<fo:table-column column-width="3.5cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-body>
														<fo:table-row>
															<fo:table-cell>
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f01c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f01c0204" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="2.7cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f01c0507" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3.5cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f02c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f02c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f02c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f02c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f02c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f02c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f02c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f03c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f03c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f03c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f03c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f03c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f03c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f03c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f04c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f04c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f04c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f04c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f04c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f04c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f04c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03l_f05c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f05c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f05c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f05c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f05c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f05c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta03v_f05c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>




						<fo:block>
							<fo:table width="100%" space-before.optimum="4pt"
								space-after.optimum="4pt">
								<fo:table-column column-width="27cm" />
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell padding-before="0cm" width="27cm"
											padding-start="3pt" padding-end="3pt" padding-after="3pt">
											<fo:block>
												<fo:table width="100%" space-before.optimum="6pt"
													space-after.optimum="13pt">
													<fo:table-column column-width="5cm" />
													<fo:table-column column-width="3.5cm" />
													<fo:table-column column-width="3.5cm" />
													<fo:table-column column-width="3.0cm" />
													<fo:table-column column-width="3.0cm" />
													<fo:table-column column-width="3.0cm" />
													<fo:table-body>
														<fo:table-row>
															<fo:table-cell number-rows-spanned="2"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb03l_f01c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb03l_f01c0203" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="2.7cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb03l_f01c0405" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-rows-spanned="2"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb03l_f01c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb03l_f02c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb03l_f02c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb03l_f02c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb03l_f02c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3.5cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb03v_f03c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb03v_f03c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb03v_f03c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb03v_f03c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb03v_f03c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb03v_f03c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>








						<fo:block>
							<fo:inline font-size="10pt" font-weight="bold"
								text-decoration="underline">
								<xsl:value-of select="//informeDEC/corrM2/ta04t" />
							</fo:inline>
						</fo:block>
						<fo:block>
							<fo:table width="100%" space-before.optimum="13pt"
								space-after.optimum="6pt">
								<fo:table-column column-width="27cm"></fo:table-column>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell padding-before="0cm" width="27cm"
											padding-start="3pt" padding-end="3pt" padding-after="3pt">
											<fo:block>
												<fo:table width="100%" space-before.optimum="4pt"
													space-after.optimum="4pt">
													<fo:table-column column-width="1.5cm"></fo:table-column>
													<fo:table-column column-width="3.5cm"></fo:table-column>
													<fo:table-column column-width="3.5cm"></fo:table-column>
													<fo:table-column column-width="3.5cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-column column-width="3cm"></fo:table-column>
													<fo:table-body>
														<fo:table-row>
															<fo:table-cell>
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f01c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f01c0204" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="2.7cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f01c0507" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3.5cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f02c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f02c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f02c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f02c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f02c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f02c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f02c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f03c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f03c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f03c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f03c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f03c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f03c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f03c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f04c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f04c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f04c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f04c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f04c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f04c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f04c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" width="3.5cm" padding-start="3pt"
																padding-end="3pt" padding-before="3pt" padding-after="3pt"
																border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04l_f05c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f05c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f05c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f05c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f05c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f05c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/ta04v_f05c07" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>






						<fo:block>
							<fo:table width="100%" space-before.optimum="4pt"
								space-after.optimum="4pt">
								<fo:table-column column-width="27cm" />
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell padding-before="0cm" width="27cm"
											padding-start="3pt" padding-end="3pt" padding-after="3pt">
											<fo:block>
												<fo:table width="100%" space-before.optimum="6pt"
													space-after.optimum="13pt">
													<fo:table-column column-width="5cm" />
													<fo:table-column column-width="3.5cm" />
													<fo:table-column column-width="3.5cm" />
													<fo:table-column column-width="3.0cm" />
													<fo:table-column column-width="3.0cm" />
													<fo:table-column column-width="3.0cm" />
													<fo:table-body>
														<fo:table-row>
															<fo:table-cell number-rows-spanned="2"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb04l_f01c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb04l_f01c0203" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="2.7cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb04l_f01c0405" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-rows-spanned="2"
																background-color="#5175B9" border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" line-height="3mm" text-align="center"
																width="10.5cm" padding-start="3pt" padding-end="3pt"
																padding-before="3pt" padding-after="3pt" border-style="solid"
																border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb04l_f01c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb04l_f02c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb04l_f02c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb04l_f02c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell background-color="#5175B9"
																border-after-color="#CAC9D9" border-after-style="solid"
																border-after-width="thin" border-before-color="#CAC9D9"
																border-before-style="solid" border-before-width="thin"
																border-end-color="#CAC9D9" border-end-style="solid"
																border-end-width="thin" border-start-color="#CAC9D9"
																border-start-style="solid" border-start-width="thin"
																line-height="3mm" text-align="center" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline color="white" font-size="8pt"
																		font-weight="bold">
																		<xsl:value-of select="//informeDEC/corrM2/tb04l_f02c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3.5cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt" border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb04v_f03c01" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb04v_f03c02" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb04v_f03c03" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="1.3cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb04v_f03c04" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb04v_f03c05" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell border-after-color="#CAC9D9"
																border-after-style="solid" border-after-width="thin"
																border-before-color="#CAC9D9" border-before-style="solid"
																border-before-width="thin" border-end-color="#CAC9D9"
																border-end-style="solid" border-end-width="thin"
																border-start-color="#CAC9D9" border-start-style="solid"
																border-start-width="thin" text-align="right" width="2.7cm"
																padding-start="3pt" padding-end="3pt" padding-before="3pt"
																padding-after="3pt" border-style="solid" border-width="1pt"
																border-color="black">
																<fo:block>
																	<fo:inline font-size="8pt">
																		<xsl:value-of select="//informeDEC/corrM2/tb04v_f03c06" />
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</fo:block>


						<fo:block id="end"/>




	</xsl:template>







<!-- 	<xsl:template match="informeDEC/corrM3"> -->
<!-- 						<fo:block> -->
<!-- 							<fo:inline font-size="10pt" font-weight="bold" -->
<!-- 								text-decoration="underline"> -->
<!-- 								<xsl:value-of select="//informeDEC/corrM3/ta05t" /> -->
<!-- 							</fo:inline> -->
<!-- 						</fo:block> -->
<!-- 						<fo:block> -->
<!-- 							<fo:table width="100%" space-before.optimum="4pt" -->
<!-- 								space-after.optimum="4pt"> -->
<!-- 								<fo:table-column column-width="7cm"></fo:table-column> -->
<!-- 								<fo:table-body> -->
<!-- 									<fo:table-row> -->
<!-- 										<fo:table-cell padding-before="0cm" width="7cm" -->
<!-- 											padding-start="3pt" padding-end="3pt" padding-after="3pt"> -->
<!-- 											<fo:block> -->
<!-- 												<fo:table width="100%" space-before.optimum="4pt" -->
<!-- 													space-after.optimum="4pt"> -->
<!-- 													<fo:table-column column-width="3.5cm"></fo:table-column> -->
<!-- 													<fo:table-column column-width="3.5cm"></fo:table-column> -->
													
<!-- 													<fo:table-header> -->
<!-- 														<fo:table-row> -->
<!-- 															<fo:table-cell number-columns-spanned="2" -->
<!-- 																background-color="#5175B9" border-after-color="#CAC9D9" -->
<!-- 																border-after-style="solid" border-after-width="thin" -->
<!-- 																border-before-color="#CAC9D9" border-before-style="solid" -->
<!-- 																border-before-width="thin" border-end-color="#CAC9D9" -->
<!-- 																border-end-style="solid" border-end-width="thin" -->
<!-- 																border-start-color="#CAC9D9" border-start-style="solid" -->
<!-- 																border-start-width="thin" line-height="3mm" text-align="center" -->
<!-- 																width="7cm" padding-start="3pt" padding-end="3pt" -->
<!-- 																padding-before="3pt" padding-after="3pt" border-style="solid" -->
<!-- 																border-width="1pt" border-color="black"> -->
<!-- 																<fo:block> -->
<!-- 																	<fo:inline color="white" font-size="8pt" -->
<!-- 																		font-weight="bold"> -->
<!-- 																		<xsl:value-of select="//informeDEC/corrM3/ta05l_f01c0102" /> -->
<!-- 																	</fo:inline> -->
<!-- 																</fo:block> -->
<!-- 															</fo:table-cell> -->
<!-- 														</fo:table-row> -->
<!-- 														<fo:table-row> -->
<!-- 															<fo:table-cell background-color="#5175B9" -->
<!-- 																border-after-color="#CAC9D9" border-after-style="solid" -->
<!-- 																border-after-width="thin" border-before-color="#CAC9D9" -->
<!-- 																border-before-style="solid" border-before-width="thin" -->
<!-- 																border-end-color="#CAC9D9" border-end-style="solid" -->
<!-- 																border-end-width="thin" border-start-color="#CAC9D9" -->
<!-- 																border-start-style="solid" border-start-width="thin" -->
<!-- 																line-height="3mm" text-align="center" width="3.5cm" -->
<!-- 																padding-start="3pt" padding-end="3pt" padding-before="3pt" -->
<!-- 																padding-after="3pt" border-style="solid" border-width="1pt" -->
<!-- 																border-color="black"> -->
<!-- 																<fo:block> -->
<!-- 																	<fo:inline color="white" font-size="8pt" -->
<!-- 																		font-weight="bold"> -->
<!-- 																		<xsl:value-of select="//informeDEC/corrM3/ta05l_f02c01" /> -->
<!-- 																	</fo:inline> -->
<!-- 																</fo:block> -->
<!-- 															</fo:table-cell> -->
<!-- 															<fo:table-cell background-color="#5175B9" -->
<!-- 																border-after-color="#CAC9D9" border-after-style="solid" -->
<!-- 																border-after-width="thin" border-before-color="#CAC9D9" -->
<!-- 																border-before-style="solid" border-before-width="thin" -->
<!-- 																border-end-color="#CAC9D9" border-end-style="solid" -->
<!-- 																border-end-width="thin" border-start-color="#CAC9D9" -->
<!-- 																border-start-style="solid" border-start-width="thin" -->
<!-- 																line-height="3mm" text-align="center" width="3.5cm" -->
<!-- 																padding-start="3pt" padding-end="3pt" padding-before="3pt" -->
<!-- 																padding-after="3pt" border-style="solid" border-width="1pt" -->
<!-- 																border-color="black"> -->
<!-- 																<fo:block> -->
<!-- 																	<fo:inline color="white" font-size="8pt" -->
<!-- 																		font-weight="bold"> -->
<!-- 																		<xsl:value-of select="//informeDEC/corrM3/ta05l_f02c02" /> -->
<!-- 																	</fo:inline> -->
<!-- 																</fo:block> -->
<!-- 															</fo:table-cell> -->
<!-- 														</fo:table-row> -->
<!-- 													</fo:table-header> -->


<!-- 													<fo:table-body> -->
<!--        													<xsl:for-each select="//informeDEC/corrM3/ta05d"> -->
<!-- 															<fo:table-row> -->
<!-- 																		<fo:table-cell  border-after-color="#CAC9D9" -->
<!-- 																			border-after-style="solid" border-after-width="thin" -->
<!-- 																			border-before-color="#CAC9D9" border-before-style="solid" -->
<!-- 																			border-before-width="thin" border-end-color="#CAC9D9" -->
<!-- 																			border-end-style="solid" border-end-width="thin" -->
<!-- 																			border-start-color="#CAC9D9" border-start-style="solid" -->
<!-- 																			border-start-width="thin" text-align="left" width="3.5cm" padding-start="3pt" -->
<!-- 																			padding-end="3pt" padding-before="3pt" padding-after="3pt" -->
<!-- 																			border-style="solid" border-width="1pt" border-color="black"> -->
<!-- 																			<fo:block> -->
<!-- 																				<fo:inline font-size="8pt"> -->
<!-- 																					<xsl:value-of select="ta05v_f03c01" /> -->
<!-- 																				</fo:inline> -->
<!-- 																			</fo:block> -->
<!-- 																		</fo:table-cell> -->
<!-- 																		<fo:table-cell border-after-color="#CAC9D9" border-after-style="solid" -->
<!-- 																			border-after-width="thin" border-before-color="#CAC9D9" -->
<!-- 																			border-before-style="solid" border-before-width="thin" -->
<!-- 																			border-end-color="#CAC9D9" border-end-style="solid" -->
<!-- 																			border-end-width="thin" border-start-color="#CAC9D9" -->
<!-- 																			border-start-style="solid" border-start-width="thin" -->
<!-- 																			line-height="3mm" text-align="right" width="3.5cm" -->
<!-- 																			padding-start="3pt" padding-end="3pt" padding-before="3pt" -->
<!-- 																			padding-after="3pt" border-style="solid" border-width="1pt" -->
<!-- 																			border-color="black"> -->
<!-- 																			<fo:block> -->
<!-- 																				<fo:inline font-size="8pt"> -->
<!-- 																					<xsl:value-of select="ta05v_f03c02" /> -->
<!-- 																				</fo:inline> -->
<!-- 																			</fo:block> -->
<!-- 																		</fo:table-cell> -->
<!-- 															</fo:table-row> -->
<!--        													</xsl:for-each> -->
<!-- 													</fo:table-body> -->
<!-- 												</fo:table> -->
<!-- 											</fo:block> -->
<!-- 										</fo:table-cell> -->
<!-- 									</fo:table-row> -->
<!-- 								</fo:table-body> -->
<!-- 							</fo:table> -->
<!-- 						</fo:block> -->


<!-- 						<fo:block id="end"/> -->





<!-- 	</xsl:template> -->










</xsl:stylesheet>
